//+------------------------------------------------------------------+
#property copyright "Daniel Jose"
//+------------------------------------------------------------------+
void OnStart(void)
{
    const ulong info = 0xA1B2C3D4E5F6789A;

    PrintFormat("Before modification: 0x%I64X", info);
    PrintFormat("After modification : 0x%I64X", Swap(info));
}
//+------------------------------------------------------------------+
ulong Swap(ulong arg)
{
    union un_01
    {
        ulong   value;
        uchar   u8_bits[sizeof(ulong)];
    }info;

    info.value = arg;

    PrintFormat("The region is composed of %d bytes", sizeof(info));

    for (uchar i = 0, j = sizeof(info) - 1, tmp; i < j; i++, j--)
    {
        tmp = info.u8_bits[i];
        info.u8_bits[i] = info.u8_bits[j];
        info.u8_bits[j] = tmp;
    }

    return info.value;
}
//+------------------------------------------------------------------+